/*
 * Decompiled with CFR 0.152.
 */
package forge.net.nimajnebec.autoelytra.mixin;

import com.mojang.authlib.GameProfile;
import forge.net.nimajnebec.autoelytra.AutoElytra;
import forge.net.nimajnebec.autoelytra.config.Configuration;
import forge.net.nimajnebec.autoelytra.feature.AutoEquipController;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.player.AbstractClientPlayer;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.core.NonNullList;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.ClickType;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ElytraItem;
import net.minecraft.world.item.ItemStack;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.Redirect;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={LocalPlayer.class})
public class LocalPlayerMixin
extends AbstractClientPlayer {
    @Shadow
    @Final
    protected Minecraft f_108619_;

    public LocalPlayerMixin(ClientLevel clientLevel, GameProfile gameProfile) {
        super(clientLevel, gameProfile);
    }

    @Redirect(method={"aiStep"}, at=@At(value="INVOKE", target="Lnet/minecraft/client/player/LocalPlayer;onClimbable()Z"))
    private boolean patchLavaFlight(LocalPlayer instance) {
        return this.m_6147_() || this.m_20077_();
    }

    @Inject(method={"aiStep"}, at={@At(value="INVOKE", shift=At.Shift.BEFORE, target="Lnet/minecraft/client/player/LocalPlayer;getItemBySlot(Lnet/minecraft/world/entity/EquipmentSlot;)Lnet/minecraft/world/item/ItemStack;")})
    private void tryEquipElytra(CallbackInfo ci) {
        if (!Configuration.AUTO_EQUIP_ENABLED.get().booleanValue()) {
            return;
        }
        if (this.autoelytra$canStartFlying()) {
            List<ItemStack> inventory = this.autoelytra$getCombinedInventory();
            if (inventory.get(AutoElytra.CHEST_SLOT).m_41720_() instanceof ElytraItem) {
                return;
            }
            for (int slot = 0; slot < inventory.size(); ++slot) {
                ItemStack stack = inventory.get(slot);
                if (!(stack.m_41720_() instanceof ElytraItem)) continue;
                AutoEquipController.setPreviousChestItem(inventory.get(AutoElytra.CHEST_SLOT));
                this.autoelytra$swapSlots(AutoElytra.CHEST_SLOT, slot);
                return;
            }
        }
    }

    @Unique
    private boolean autoelytra$canStartFlying() {
        return !this.m_20096_() && !this.m_21255_() && !this.m_20069_() && !this.m_21023_(MobEffects.f_19620_);
    }

    @Inject(method={"aiStep"}, at={@At(value="TAIL")})
    private void unequipElytra(CallbackInfo ci) {
        if (!Configuration.AUTO_EQUIP_ENABLED.get().booleanValue()) {
            return;
        }
        List<ItemStack> inventory = this.autoelytra$getCombinedInventory();
        if (AutoEquipController.hasPreviousChestItem() && !this.m_21255_() && inventory.get(AutoElytra.CHEST_SLOT).m_41720_() instanceof ElytraItem) {
            for (int slot = 0; slot < inventory.size(); ++slot) {
                if (!AutoEquipController.matchesPreviousChestItem(inventory.get(slot))) continue;
                this.autoelytra$swapSlots(AutoElytra.CHEST_SLOT, slot);
                break;
            }
            AutoEquipController.resetPreviousChestItem();
        }
    }

    @Unique
    private void autoelytra$swapSlots(int slotA, int slotB) {
        NonNullList slots = this.f_36095_.f_38839_;
        int slotAMenu = -1;
        int slotBMenu = -1;
        for (int i = 5; i < slots.size(); ++i) {
            if (((Slot)slots.get(i)).m_150661_() == slotA) {
                slotAMenu = i;
            }
            if (((Slot)slots.get(i)).m_150661_() == slotB) {
                slotBMenu = i;
            }
            if (slotAMenu > -1 && slotBMenu > -1) break;
        }
        assert (slotAMenu > -1);
        assert (slotBMenu > -1);
        assert (this.f_108619_.f_91072_ != null);
        this.f_108619_.f_91072_.m_171799_(this.f_36095_.f_38840_, slotAMenu, 0, ClickType.PICKUP, (Player)this);
        this.f_108619_.f_91072_.m_171799_(this.f_36095_.f_38840_, slotBMenu, 0, ClickType.PICKUP, (Player)this);
        this.f_108619_.f_91072_.m_171799_(this.f_36095_.f_38840_, slotAMenu, 0, ClickType.PICKUP, (Player)this);
    }

    @Unique
    private List<ItemStack> autoelytra$getCombinedInventory() {
        Inventory inventory = this.m_150109_();
        ArrayList<ItemStack> result = new ArrayList<ItemStack>();
        for (NonNullList compartment : inventory.f_35979_) {
            result.addAll((Collection<ItemStack>)compartment);
        }
        return result;
    }
}

